/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef BALANCE_H
#define BALANCE_H

#ifndef MK
#   include "include/sys/types.h"
#endif

#if defined(__cplusplus) || defined(CPLUSPLUS)
extern "C" {
#endif

typedef struct {
    void *data;
    size_t length;
} _balanced_tree_key;

typedef struct __balanced_tree_node {
    struct __balanced_tree_node *l, *r;
    _balanced_tree_key key;
	const void *data;
    signed char factor;
} _balanced_tree_node;

typedef struct {
    _balanced_tree_node *top_node, *position, *adjust_at, *bal_at, *bal_parent;
    _balanced_tree_node **path;
    short plen, max_plen, treeerror, flag;
    int pos;
} _balanced_tree;

#define BALTREE_MALLOC_KEYS 1		/* for flags */
#define BALTREE_FAST_KEYS 2			/* for flags - no sorting ! */
void baltree_construct(_balanced_tree *,int flags);
void baltree_destroy(_balanced_tree *);
short baltree_error(const _balanced_tree *);
short baltree_height(const _balanced_tree *);
int baltree_validate(_balanced_tree *);
const void *baltree_get(_balanced_tree *,const void *,int);
int baltree_insert(_balanced_tree *,const void *,int,const void *);
const void *baltree_replace(_balanced_tree *,const void *,int,const void *);
const void *baltree_put(_balanced_tree *,const void *,int,const void *);
const void *baltree_del(_balanced_tree *,const void *,int);
void baltree_first(_balanced_tree *);
void baltree_last(_balanced_tree *);
const void *baltree_next(_balanced_tree *);
const void *baltree_prev(_balanced_tree *);
void baltree_setbefore(_balanced_tree *,const void *,int);
void baltree_setafter(_balanced_tree *,const void *,int);
const _balanced_tree_key *baltree_topnodekey(const _balanced_tree *);
const _balanced_tree_key *baltree_key(const _balanced_tree *);
int baltree_keycmp(const _balanced_tree_key *,const _balanced_tree_key *,
				   int fast);
#if defined(__cplusplus) || defined(CPLUSPLUS)
}
#endif
#endif
