//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "dlist.inc"
#	endif
#   endif
#else
#   include "dlist.h"
#   include "include/string.h"
#   include "include/malloc.h"
#   ifdef MSDOS
#	include "include/io.h"
#   else
#	include "include/prototyp.h"
#   endif
#endif

static void default_handler(const char *str){
    write(2,str,strlen(str));
    write(2,"\n",1);
    exit(1);
}

PFC Dlist::handler = default_handler;

void Dlist::start(){
    if( root ){
		current = root->next;
		lpos = 1;
    }
}

int Dlist::linkafter(void* ent){
    dnode *t;
    if(t = mem_new dnode, !t) return -1;
    if(!root){
		t->next = t->prev = root = t;
		t->body = ent;
    }else{
		if(current == root) root = t;
        current->next->prev = t;
		t->next = current->next;
		current->next = t;
		t->prev = current;
		t->body = ent;
    }
    current = t;
    lpos++;
    count++;
    return(0);
}

int Dlist::linkbefore(void* ent){
    dnode *t;
    if(t = mem_new dnode, !t) return -1;
    if(!root){
		current = t->prev = t->next = root = t;
		t->body = ent;
    }else{
		current->prev->next = t;
		t->prev = current->prev;
		current->prev = t;
		t->next = current;
		t->body = ent;
		current = t;
		lpos++;
    }
    count++;
    return 0;
}

void* Dlist::linkout(){
    dnode *t;
    void *r;
	
    if(!root){
		Dlist::handler("Dlist - attempted linkout from empty list");
		return 0;
    }
    if(current == root){
		if(count == 1){
			r = root->body;
			mem_delete root;
			current = 0;
		}else{
			current = root->prev;
			root->next->prev = current;
			current->next = root->next;
			r = root->body;
			mem_delete root;
		}
		root = current;
		count--;
		lpos--;
    }else{
		t = current->next;
		current->prev->next = t;
		t->prev = current->prev;
		r = current->body;
		mem_delete current;
		current = t;
		count--;
    }
    return r;
}

void Dlist::cleanup(){
    dnode *t;
    if(!root) return;
    while(--count){
        t = root->next;
        mem_delete root;
        root = t;
    }
    mem_delete root;
    current = root = 0;
    lpos = 0;
}

void *Dlist::get() const {
    if(!root){
        Dlist::handler("Dlist - attempted get from empty list");
        return 0;
    }
    return current->body;
}

PFC Dlist::set_handler(PFC new_handler){
    PFC local = Dlist::handler;
    Dlist::handler = new_handler;
    return local;
}

void Dlist::fwd(int n){
    while(n-- && lpos < count){ current = current->next; lpos++; }
}

void Dlist::bkwd(int n){
    while(n--&& lpos > 1){ current = current->prev; lpos--; }
}
