/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "etest.inc"
#	endif
#   endif
#else
#   include "expand.h"
#   include "include/stdio.h"
#   include "include/memory.h"
#endif

#if defined( MSDOS ) | defined( OS2 )

#if defined( __ZTC__ ) | defined( OS2 )
#   define coreleft() (unsigned long)0
#endif

int main(int argc,char **argv){
    int f;
    unsigned long start = coreleft(), mid;

    if(!expand(&argc,&argv)){
	puts("Failed to expand arguements");
	return 1;
    }
    mid = coreleft();

    fputs(*argv,stdout);
    for(f = 1; f < argc; f++){
	fputs(" \"",stdout);
	fputs(argv[f],stdout);
	putchar('"');
    }
    putchar('\n');

    unexpand(&argc,&argv);
    printf("Initally, coresize was %lu.\n",start);
    printf("After expand, coresize was %lu.\n",mid);
    printf("After unexpand, coresize is %lu.\n",coreleft());
	
    return 0;
}

#else /* MSDOS | OS2 */

int main(){ puts("This program only runs under MSDOS"); return 1; }

#endif
