/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#include <stdio.h>
#include <signal.h>

void sighandle(int sig){
    fprintf(stderr,"%d: sig %d\n",getpid(),sig);
    signal(sig,SIG_IGN);
    kill(0,SIGINT);
}

void dosys(){
    int ret = system("exec sleep 10");
    fprintf(stderr,"%d: sleep done %d\n",getpid(),ret);
    pause();
    exit(ret);
}

main(){
    pid_t p, ret;
    int status, f;

    setpgrp();

    signal(SIGINT,sighandle);
    for(f = 0; f < 5; f++){
	switch(p = fork(), p){
	    case -1:
		fprintf(stderr,"%d: Cannot fork\n",getpid());
		perror("");
		return 1;
	    case 0:
		dosys();
	}
	fprintf(stderr,"%d: spawned %d\n",getpid(),p);
    }
    while(ret = wait(&status), ret != -1)
	fprintf(stderr,"%d: %d done %d\n",getpid(),ret,status);
    fprintf(stderr,"%d: wait failed ",getpid());
    perror("");
    return 0;
}
