/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef P_STRING_H
#define P_STRING_H

class PointerString : public String {
protected:
    void Equals(const char *,size_t);
    void PlusEquals(const char *,size_t);

public:
    ~PointerString(){}
    PointerString( const char *s ){ this->Equals(s,strlen(s)); }
    PointerString( const char *s, size_t Len ){ this->Equals(s,Len); }
    PointerString( const String &s ){ this->Equals(s.Ptr(),s.Len()); }
    PointerString( const PointerString &s ){ this->Equals(s.Ptr(),s.Len()); }

    String operator+(const String &) const;
    size_t SetLen(size_t);

    const String operator()(size_t Start, size_t Len) const;
    String operator()(size_t Start, size_t Len);

    String &operator=(const char *s){ this->Equals(s,strlen(s)); return *this; }
    String &operator=(const String &s){ this->Equals(s.Ptr(),s.Len()); return *this; }

    String &operator+=(const char *s){ this->PlusEquals(s,strlen(s)); return *this; }
    String &operator+=(const String &s){ this->PlusEquals(s.Ptr(),s.Len()); return *this; }
};

#endif
