//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#include "string.inc"

void String::Equals(const char *s,size_t Len){
    this->SetLen(Len);
    memcpy(this->Data,s,this->Length);
}

void String::PlusEquals(const char *s,size_t Len){
    size_t OldLen = this->Length;
    this->SetLen(this->Length + Len);
    memcpy( this->Data + OldLen, s, this->Length-OldLen );
}

const char *String::Ptr(size_t Offset) const {
    if(Offset >= this->Length){ String::NoChar = '\0'; return &String::NoChar; }
    return this->Data + Offset;
}

off_t String::Chr(char ch) const {
    char *Ptr = (char *)memchr( this->Data, ch, this->Length );
    if(Ptr) return Ptr - this->Data;
    return -1;
}

off_t String::Rchr(char ch) const {
    const char *Ptr = this->Data + this->Length;
    while( Ptr-- > this->Data ) if( *Ptr == ch ) return Ptr - this->Data;
    return -1;
}

int String::Cmp(const String &s) const {
    int Result = 0;
    int Len = this->Length;
    if( this->Length > s.Length ){ Result = 1; Len = s.Length; }
    else if( this->Length < s.Length ) Result = -1;
    int Cmp = memcmp( this->Data, s.Data, Len );
    if(!Cmp) Cmp = Result;
    return Cmp;
}

char &String::operator[](size_t Pos){
    if(Pos < this->Length) return this->Data[Pos];
    if(Pos == this->Length){ this->SetLen(Pos+1); return this->Data[Pos] = '\0'; }
    String::NoChar = '\0';
    return String::NoChar;
}

char String::operator[](size_t Pos) const {
    if(Pos <= this->Length) return this->Data[Pos];
    return '\0';
}

void String::Insert(size_t From, size_t Len){
    size_t OldLen = this->Length;
    if(Len = this->SetLen(OldLen + Len) - OldLen, !Len) return;
    size_t End = From + Len;
    for(int f = this->Length - 1; f >= End; f--)
	this->Data[f] = this->Data[f-Len];
}

void String::Delete(size_t From, size_t Len){
    if(From > this->Length) return;
    if(From + Len > this->Length){
	this->SetLen(From);
	return;
    }
    for(int f = From + Len; f < this->Length; f++)
	this->Data[f-Len] = this->Data[f];
    this->SetLen(this->Length - Len);
}

String::operator char *( void ){
    this->Data[ this->Length ] = '\0';
    return this->Data;
}
