/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef STRING_H
#define STRING_H

#ifndef MK
#   include <sys/types.h>
#   include <string.h>
#endif

class String {
protected:
    char *Data;
    size_t Length;
    static char NoChar;
    virtual void Equals(const char *,size_t);
    virtual void PlusEquals(const char *,size_t);

public:
    virtual ~String(){}
    const char *Ptr(size_t Offset = 0) const;
    size_t Len(void) const { return this->Length; }
    off_t Chr(char) const;
    off_t Rchr(char) const;

    int Cmp(const String &) const;
    int operator==(const String &s) const { return this->Cmp(s) ? 0 : 1; }
    int operator!=(const String &s) const { return this->Cmp(s) ? 1 : 0; }
    int operator<(const String &s) const { return this->Cmp(s) < 0 ? 1 : 0; }
    int operator<=(const String &s) const { return this->Cmp(s) > 0 ? 0 : 1; }
    int operator>(const String &s) const { return this->Cmp(s) > 0 ? 1 : 0; }
    int operator>=(const String &s) const { return this->Cmp(s) < 0 ? 0 : 1; }

    char operator[](size_t) const;
    char &operator[](size_t);

    void Insert(size_t From, size_t Len);
    void Delete(size_t From, size_t Len);
    operator char *( void );

    virtual String operator+(const String &) const = 0;
    virtual size_t SetLen(size_t) = 0;

    virtual const String operator()(size_t Start, size_t Len) const = 0;
    virtual String operator()(size_t Start, size_t Len) = 0;

    String &operator=(const char *s){ this->Equals(s,strlen(s)); return *this; }
    String &operator=(const String &s){ this->Equals(s.Ptr(),s.Len()); return *this; }

    String &operator+=(const char *s){ this->PlusEquals(s,strlen(s)); return *this; }
    String &operator+=(const String &s){ this->PlusEquals(s.Ptr(),s.Len()); return *this; }
};

#endif
