//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "allocate.inc"
#	endif
#   endif
#else
#   include "allocate.h"
#   include "common/balance.h"
#   include "common/string.h"
#   include "include/malloc.h"
#endif

static _balanced_tree items;
static int refcount = 0;

allocator::allocator(){
    if(!refcount++) baltree_construct(&items,0);
}
#include <stdio.h>

allocator::~allocator(){
    if(!--refcount){
	String *s;
	baltree_first(&items);
	while(s = (String *)baltree_next(&items), s)
	    mem_delete (String *)baltree_del(&items,(char *)*s,s->len()+1);
	baltree_destroy(&items);
    }
}

String &allocator::stringref(const String &s){
    String *insert;
    if(insert = (String *)baltree_get(&items,(char *)s,s.len()+1), insert)
	return *insert;
    insert = mem_new String(s);
    baltree_insert(&items,(char *)*insert,insert->len()+1,(void *)insert);
    return *insert;
}

char *allocator::charptr(const String &s){
    return (char *)this->stringref(s);
}
