/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef DEFAULT_H
#define DEFAULT_H

#ifndef MK
#   include "allocate.h"
#   include "common/balance.h"
#endif
			//	 	    defaults:
			//	directive		value
enum default_type {
    INVALID_TYPE = -1,	// THESE MUST BE SORTED FOR DIRECTIVES ARRAY !
    BINARY_NAME,	//	***			$*.exe
    CODE_NAME,		//	#code_extension		$*.c
    CODE_NEEDS,		//	#code_needs		***
    COMPILE,		//	#compile		$(CC) -c $<
    DERIVE,		//	#derive			***
    INCLUDE_LINE,	//  *   #include_line		#include "$#/$@"
    INCLUDE_LINE_CONT,	//  *   #include_line_cont	
    INCLUDE_NAME,	//	***			$*.inc
    INTERFACE_NAME,	//	#interface_extension	$*.h
    INTERFACE_NEEDS,	//	#interface_needs	***
    LOAD,		//	#load			$(CC) -e$@ @$&
    LOCK_NAME,		//	#lock_extension		$*.lck
    MK_NAME,		//	***			$*.mk
    OBJECT_NAME,	//	#object_extension	$*.obj
    OBJECT_NEEDS,	//	#object_needs		***
    RESPONSE_LINE,	//  *   #response_line		$#$@
    RESPONSE_LINE_CONT,	//  *   #response_line_cont	
    RESPONSE_NAME,	//	***			$*.rsp
    TARGET		//	#target			***
};
#define NDEFAULTS (19)

// *   = $* expansion allowed
// *** = not applicable

class default_t {
    String **directive_overrides;
    String **value_overrides;
    allocator allocate;
    _balanced_tree defines[NDEFAULTS];
public:
    default_t();
    ~default_t();
    const String &directive(default_type);
    const String &value(default_type);
    void define(default_type,const String &from,const String &to,
		const String &file,int lineno);
    void set_directive(default_type,const String &value);
    void set_value(default_type,String &value);
    default_type type(const String &s);
    default_type evaluate(String &s);
    void do_defines(String &,default_type);
};

void ExpandName( String &Name, const char *fmt );

#endif /* DEFAULT_H */
