/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef JOBS_H
#define JOBS_H

#ifndef MK
#   include "include/sys/types.h"
#   include "module.h"
#endif

// Don't conflict with the stuff in module.h
#define JOB_FAILED_WAIT 100
#define JOB_FAILED_UNLOCK 101

struct job_proc {
    pid_t pid;
    action act;
    int priority;
    job_proc(pid_t p,action &a,int pr){ pid = p; act = a; priority = pr; }
};

class jobs {
    int max, running;
    job_proc **proc_list;
#ifndef MSDOS
    int child;
#endif
    int wait(action &);
    // priority 0 runs on its own.  No job can run while higher priorities are
    // running.
    int runable(int priority);
public:
    jobs(int parallel);
    int execute(action &finished,action &,const char *rmfmt,int priority,
		int quiet,int doit);
    void killall(int sig);
    int finish(action &finished);
    int isrunning(const action &) const;
    int waitfor(action &);
    ~jobs();
};
#endif
