/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef MODULE_H
#define MODULE_H

#ifndef MK
#   include "common/dlist.h"
#   include "common/balance.h"
#   include "common/string.h"
#   include "defaults.h"
#   include "include/time.h"
#   include "mapping.h"
#   include "include/stdlib.h"
#   include "include/malloc.h"
#endif

struct hlist {
    Dlist list;		// points to a module
    time_t newest;
    hlist(){ newest = 0; }
};

class target_t {
	public:
    time_t a_time, orig_a_time;
    char *namefmt;
	target_t(void){ a_time = orig_a_time = 0; namefmt = 0; }
};

class derive_t {
	public:
    time_t src_time;
    char *namefmt;
    char *compile;
	derive_t(void){ src_time = 0; namefmt = compile = 0; }
};

enum file_type { C_F, D_F, H_F, O_F, A_F, M_F, I_F, R_F };
const n_file_types = 8;

// Don't conflict with the stuff in jobs.h
#define MODULE_NOT_COMPILED (102)

class module {
    int flags;
    _balanced_tree_key k;
    String *namebuf;
    String *mapped, *half_mapped_name;
public:
    int isvalid(void) const;
    void makevalid(void);
    int ismapped() const;
	int hasmapped() const;
	int hasinterfacemapped() const;
	int HalfMap(mapping *, int Verbose, int Object = 0);
	int objecthalfmapped() const;
	char *HalfMappedName(void) const
		{ return this->half_mapped_name ? (char *)*this->half_mapped_name : 0; }
	void now_hasmapped();
	void now_hasinterfacemapped();
    void reversemap();
    const char *realname(void) const;
    const char *name(void) const;
    const char *module::object_prefix() const;
    int reallen(void) const { return k.length; }
    time_t gettime( file_type type,mapping *, int verbose,const char *namefmt = 0);
    int openread(const String &namefmt,mapping *,int verbose);
    module(String &name,default_t &,int = 0);
    ~module();

    hlist interface_needs, code_needs;	// only interface_needs holds lib lists
    hlist direct_objects;
    char has_mk;
    time_t object_time, code_time, interface_time, newest_interface;
    time_t orig_object_time, orig_code_time, orig_interface_time;
    char *compile;
    char *includeline, *includelinecont;
    char *load, *responseline, *responselinecont;
    char *object_namefmt, *interface_namefmt, *code_namefmt;
    target_t *target;
    derive_t *derive;
};

enum action_t { ACT_DONE, ACT_WARNING, ACT_ERROR, ACT_COMPILE,
		ACT_LOAD, ACT_INTERNAL, ACT_DERIVE };

class action {
    time_t target_time;
    char *target_namefmt;
    module *c;
    String directory;
    void Remove(const char *namefmt,int silent = 0) const;

    char *lock_namefmt, *lockedby;
public:
	String exec_command;
    const char *dir(void) const;
    const char *name(void) const { return c ? c->name() : 0; }
    const char *targetfmt(void) const { return target_namefmt; }
    const char *command(void) const;
    int system(const char *rmext,int quiet,int doit,
			   const char *post = 0) const;
    const char *prog(void) const;
    void setdir(const String &);
    action_t type;
    void reset(void);
    int Setup(module *,time_t target_time,char *target_namefmt, int Silent );
    int Compiled( int Verbose = 0 ) const;
    action(){ c = 0; lock_namefmt = lockedby = target_namefmt = 0; }
    ~action()
	{ if( lockedby ) mem_free( lockedby ); else if( lock_namefmt ) UnLock(); }
    action &operator<<(const char *);
    action &operator=(action &);

    char *get_allocated_lockname(const char *namefmt) const;
    int IsLocked(const char *namefmt);
    int Lock(const char *namefmt);
    int UnLock(void);
    void leave_lock(void);
    int IsLockedByMe(void) const { return lock_namefmt ? 1 : 0; }
    const char *LockedBy(void) const { return lockedby; }
};

#define CPTRSZ sizeof(module *)

#endif /* MODULE_H */
