//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "version.inc"
#	endif
#   endif
#else
#   include "include/stdio.h"
#   include "include/string.h"
#   include "version.h"
#endif

// version 1.*
//     Released as beta test version to Utell Intl.

// version 2.00
//     Released in binary form only


// version 2.00 - 2.01: April 18, '94
// 1   Allow $$ escape in wildcard expansion
// 2   Fix uninitialised return value for action::system (when doit is not set)
// 3   Add copyright notice for public distribution
// 4   Prepend drive letter to module names for MSDOS
// 5   make ?:relative dependencies warn as possibly wrong
// 6   add "don't change" warning to top of internally built files
// 7   correct top level out-of-date checking when component target
//     is out-of-date
// 8   Update ztc.bat config file to use extended memory
// 9   Correct possibly dereferenced null pointer in Dlist::start
// 10  Change forward-slash to back-slash in Zortech compiles

// version 2.01 - 2.02: April 20, '94
// 1   Use extended memory for tcc.bat
// 2   Support Borland C++
// 3   Add cmg-v.bat to env directory (cmg virtual memory compile)
// 4   Increase stack size to 20000 under MSDOS
// 5   Check value of doit before checking if module compiled in module::system
// 6   Add compiler manufacturer to -v option
// 7   Change forward-slash to back-slash in all MSDOS response files

// version 2.02 - 2.03: June 24, '94
// 1   Use gnumalloc and -m486 under FreeBSD.
// 2   Support lock files for multi-user compiles
// 3   Output warnings left-justified to stderr

// version 2.03 - 2.04: Aug 7, '94
// 1   Use sopen under MSDOS (allow network locking)
// 2   Support half-mapping
// 3   Reduce sorted header list in parse.cc to a pointer list

// version 2.04 - 2.05: Aug 9, '94
// 1   Use correct half-mapped object at link time
// 2   Use '\\' instead of '/' in .inc files under MSDOS
// 3   Correct re-build decision on modules dependant on mapped code
// 4   Unlock file before causing error at compile time

// version 2.05 - 2.06: Aug 10, '94
// 1   Correct check for modules that cannot be build because of mappings.

// version 2.06 - 2.07: Aug 12, '94
// 1   Support Watcom C++ 32bit under MSDOS
// 2   Use '\\' instead of '/' for MSDOS globally
// 3   Support and use 'reverse' key comparisons in balance module
// 4   Add memory debugging library
// 5   Support libraries using libraries

// version 2.07 - 2.073: Aug 20, '94
// 1   Define out memory debugging library
// 2   Make string methods tighter
// 3   Increase string lengths in chunks
// 4   Allocate balanced tree node and key in one call to malloc()
// 5   Change "/" to "\\" in buildcompletename in parse.cc under MSDOS
// 6   Build list mechanism into mkline class

// version 2.073 - 2.074: Aug 20, '94
// 1   Don't half-map because of non-existent files

// version 2.074 - 2.10: Sep 19, '94
// 1   Remove use of C++ streams
// 2   Include SET LOAD in startup file, and -L option
// 3   Port back from zortech optimizations (v 2.07*)
// 4   Sort out all returns to String::chr and String::rchr ( (size_t)-1 )
// 5   Compile memory debugging library with C compiler - not C++
// 6   Correct memory debugging allignment problem
// 7   Change various method names
// 8   Make half-map directories in action::Setup
// 9   Internal commands now call action::Compiled prior to running
// 10  Don't include header files under a target when recursing
// 11  Correct 'existant' spelling
// 12  Correct include #ifdefs in common/signals

// version 2.10 - 2.11: Jun 23, '95
// 1   Correct location of default startup file under MSDOS (broken in 2.10)
// 2   Use 'del' instead of 'rm' under MSDOS for internal (-s) commands
// 3   Don't use braces for freebsd when constructing string arrays
// 4   Fix broken use of 'make' command

// version 2.10 - 2.11: Jul 2, '95
// 1   Correct include/makefile
// 2   Rename lock methods in class module
// 3   Remove 'Already built' warning
// 4   Add module::IsLocked, and call a module is already compiled

// version 2.11 - 2.13: Dec 6, '95
// 1   Correct capitalization when complaining about locked files
// 2   Port to OS/2 Warp Connect (gcc/emx)
// 3   Set retry_priority stuff when a warning ("locked by") is encountered
// 4   Change _extension to _name for targets etc.

// version 2.13 - 2.14: Jan 31, '96
// 1   Port to gcc-2.6.3 on dynix, PTX, AIX & Unixware

// version 2.14 - 2.15: Sep 27, '96
// 1   Give up on files that are locked too long

// version 2.15 - 2.151: Oct 7, '96
// 1   Remove unused variables & tidy up warnings
// 2   Add MEM_PARANOID and MEM_SHOWCALLS options

// version 2.151 - 2.152: Oct 15, '96
// 1   Add some verbosity to module::Compiled()
// 2   Fix recent fall-thru switch screw up when checking EXE actions
// 3   Better reporting of allocations outside of mem_init/mem_term.
// 4   Block after spawning max process, not before spawning next (locking)

// version 2.152 - 2.153: Oct 22, '96
// 1   Fix ExpandName in defaults.cc (passing (char *)0)
// 2   Remove size_t/int warnings in string.cc defaults.cc & parse.cc
// 3   Check expand() return (effects MSDOS only)

// version 2.153 - 2.16: Oct 28, '96
// 1   Treat command line args as mapped if -m is specified
// 2   Jump through loops to link on Sequent PTX
// 3   Fix top level makefile for broken (insist on -print) find.

// version 2.16 - 2.17: Oct 29, '96
// 1   Add support for the #derive directive

// version 2.17 - 2.18: Nov 1, '96
// 1   Get the build priorities right.
// 2   Don't complain about "has been updated" when it's a target .cc/.h
// 3   Set process group before kill(0,...)

// version 2.18 - 2.181: Jan 14, '97
// 1   Port to unixware

// version 2.181 - 2.182: Apr 19, '98
// 1   Port to SCO Openserver 5

int version(const char *prog){
    fputs( prog, stderr );
    if(strcmp(prog,"mk")) fputs( " [mk]", stderr );
    fputs( " version 2.182 (", stderr );
#ifdef __TURBOC__
#   ifdef __BORLANDC__
	fputs( "Borland C++", stderr );
#   else
	fputs( "Turbo C++", stderr );
#   endif
#endif
#ifdef __GNUC__
    fputs( "Gnu C++", stderr );
#   if __GNUC__ < 2
	fputs( " version 1", stderr );
#   endif
#   ifdef OS2
	fputs( " using emx", stderr );
#   endif
#endif
#ifdef __ZTC__
    fputs( "Zortech C++", stderr );
#endif
#ifdef __WATCOMC__
    fputs( "Watcom C++", stderr );
#endif
#ifdef MEM_DEBUG
    fputs( " with memory debugging", stderr );
#endif
    fputs( ")\n", stderr );
    return 0;
}
